<?php
/**
 *
 * Author: Emir Karşıyakalı
 * Website: http://emirkarsiyakali.com
 * License: GNU/GPL
 * Compatible with: MyBB 1.6
 *
 */

// Disallow direct access to this file for security reasons

if (!defined("IN_MYBB")) {
    die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("datahandler_user_update", "latestTweets_update");
$plugins->add_hook('member_profile_end', 'latestTweets_profile');
$plugins->add_hook('usercp_profile_start', 'latestTweets_templateupdate');

function latestTweets_info() {
	
	global $lang;
	$lang->load("latestTweets");	
	
    return array(
        "name" 			=> "هاك اخر تغريدات الاعضاء",
        "description" 	=> $lang->description,
        "author" 		=> "Emir Karşıyakalı",
        "website" 		=> "http://github.com/emirkarsiyakali",
        "authorsite" 	=> "http://emirkarsiyakali.com",
        "version" 		=> "1.0",
        "guid" 			=> "e523c533e47d5fde62f2cd0fc608c00a",
        "compatibility" => "*"
    );
}

function latestTweets_install() {

    global $db, $lang;
	$lang->load("latestTweets");	

    $db->delete_query("templates", "title='twitter_usercp'");

    $twitterusercp = array(
        "title" => "twitter_usercp",
        "template" => "<br />
						<fieldset class=\"trow2\">
						<legend><strong>تويتر</strong></legend>
						<table cellspacing=\"0\" cellpadding=\"{\$theme[tablespace]}\" width=\"100%\">
						<tr>
						<td colspan=\"2\"><span class=\"smalltext\">{$lang->twitter_profile}</span></td>
						</tr>
						<tr>
						<td colspan=\"2\" ><input type=\"text\" class=\"textbox\" name=\"twitter_username\" size=\"30\" value=\"{\$mybb->user[\'twitter_username\']}\" /></td>
						</tr>

						</table>
						</fieldset>",
        "sid" => '-1',
        "version" => '',
        "dateline" => TIME_NOW
    );
    $db->insert_query("templates", $twitterusercp);
    $db->query("ALTER TABLE " . TABLE_PREFIX . "users ADD twitter_username VARCHAR(15) NOT NULL AFTER msn");
}

function latestTweets_is_installed() {
    global $db;

    if ($db->field_exists("twitter_username", "users")) {
        return true;
    }

    return false;
}

function latestTweets_activate() {
    global $db, $mybb;
    include MYBB_ROOT . '/inc/adminfunctions_templates.php';

    find_replace_templatesets("usercp_profile", "#" . preg_quote('{$awaysection}') . "#i", '{$twitterusercp}{$awaysection}');
    find_replace_templatesets("member_profile", "#" . preg_quote('<td class="{$bgcolors[\'msn\']}"><a href="javascript:;" onclick="MyBB.popupWindow(\'misc.php?action=imcenter&amp;imtype=msn&amp;uid={$uid}\', \'imcenter\', 450, 300);">{$memprofile[\'msn\']}</a></td>') . "#i", '<td class="{$bgcolors[\'msn\']}"><a href="javascript:;" onclick="MyBB.popupWindow(\'misc.php?action=imcenter&amp;imtype=msn&amp;uid={$uid}\', \'imcenter\', 450, 300);">{$memprofile[\'msn\']}</a></td>{$twitterprofile}');

}

function latestTweets_deactivate() {
    global $mybb, $db;
    include MYBB_ROOT . "/inc/adminfunctions_templates.php";

    find_replace_templatesets("usercp_profile", "#" . preg_quote('{$twitterusercp}') . "#i", '', 0);
    find_replace_templatesets("member_profile", "#" . preg_quote('{$twitterprofile}') . "#i", '', 0);

}

function latestTweets_uninstall() {
    global $db;

    $db->query("ALTER TABLE " . TABLE_PREFIX . "users DROP COLUMN twitter_username");
    rebuild_settings();
}

function latestTweets_update() {
    global $mybb, $db;
    if ($mybb->input['action'] == "do_profile" && $mybb->request_method == "post") {
        $twQuery = $twQuery . "twitter_username = '" . $db->escape_string($mybb->input['twitter_username']) . "'";
        $db->query("UPDATE " . TABLE_PREFIX . "users SET " . $twQuery . " WHERE uid = " . $mybb->user['uid']);
    }
}

function latestTweets_templateupdate() {
    global $mybb, $templates, $theme, $twitterusercp;
    eval("\$twitterusercp = \"" . $templates->get("twitter_usercp") . "\";");
}


function latestTweets_profile() {
    global $mybb, $memprofile, $twitterprofile, $profiletwitter, $lang;
	$lang->load("latestTweets");		

    if ($memprofile["twitter_username"] != '') {	
		//$json 	= file_get_contents("http://twitter.com/status/user_timeline/".$memprofile["twitter_username"].".json?count=5", true);
		//$decode = json_decode($json, true);
		
		//If you want to use php's file_get_contents function(it is disable on most of server) uncomment above and comment CURL's line. 
		
		//CURL
		$json = "http://twitter.com/status/user_timeline/".$memprofile["twitter_username"].".json?count=5";
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $json);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$curlout = curl_exec($ch);
		curl_close($ch);
		
		$decode = json_decode($curlout, true);		
		//CURL
		
		foreach($decode as $each):
			$tweets[]	=	 $each["text"]." (".date("d-m-Y H.i", strtotime($each["created_at"])).") <br/>";
		endforeach;	
	
        $profiletwitter = '<a href="http://www.twitter.com/#/' . $memprofile["twitter_username"] . '"  TARGET=_BLANK>' . $memprofile["twitter_username"] . '</a>';
        $twitterprofile = "</tr><tr><td valign=\"top\" class=\"trow1\"><strong>{$lang->twitter_profile} :</strong></td><td class=\"trow1\"><img src='".$decode[0][user][profile_image_url]."' align=\"top\"/> $profiletwitter (".$decode[0][user][friends_count]." Following, ".$decode[0][user][followers_count]." Followers)</td>
		</tr><tr><td class=\"trow1\" colspan=\"2\">".implode($tweets);

	}
}

?>